<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

final class PPEOptions implements \JsonSerializable
{
    /**
     * @var string
     */
    private $sname1;

    /**
     * @var string
     */
    private $sname2;

    /**
     * @var string
     */
    private $sname3;

    /**
     * @var string
     */
    private $scountry;

    /**
     * @var string
     */
    private $szipcode;

    /**
     * @var string
     */
    private $scity;

    /**
     * @var string
     */
    private $sstreet;

    /**
     * @var string
     */
    private $sphone;

    /**
     * @var string
     */
    private $scontact;

    /**
     * @var string
     */
    private $rname1;

    /**
     * @var string
     */
    private $rname2;

    /**
     * @var string
     */
    private $rname3;

    /**
     * @var string
     */
    private $rcountry;

    /**
     * @var string
     */
    private $rzipcode;

    /**
     * @var string
     */
    private $rcity;

    /**
     * @var string
     */
    private $rstreet;

    /**
     * @var string
     */
    private $rphone;

    /**
     * @var string
     */
    private $rcontact;

    /**
     * @var string
     */
    private $references;

    /**
     * @var float
     */
    private $weight;

    public function getSenderName1(): string
    {
        return $this->sname1;
    }

    public function withSenderName1(string $name1): PPEOptions
    {
        $new = clone $this;
        $new->sname1 = $name1;

        return $new;
    }

    public function getSenderName2(): string
    {
        return $this->sname2;
    }

    public function withSenderName2(string $name2): PPEOptions
    {
        $new = clone $this;
        $new->sname2 = $name2;

        return $new;
    }

    public function getSenderName3(): string
    {
        return $this->sname3;
    }

    public function withSenderName3(string $name3): PPEOptions
    {
        $new = clone $this;
        $new->sname3 = $name3;

        return $new;
    }

    public function getSenderCountry(): string
    {
        return $this->scountry;
    }

    public function withSenderCountryIsoCode(string $country): PPEOptions
    {
        $new = clone $this;
        $new->scountry = $country;

        return $new;
    }

    public function getSenderZipCode(): string
    {
        return $this->szipcode;
    }

    public function withSenderZipCode(string $zipCode): PPEOptions
    {
        $new = clone $this;
        $new->szipcode = $zipCode;

        return $new;
    }

    public function getSenderCity(): string
    {
        return $this->scity;
    }

    public function withSenderCity(string $city): PPEOptions
    {
        $new = clone $this;
        $new->scity = $city;

        return $new;
    }

    public function getSenderStreet(): string
    {
        return $this->sstreet;
    }

    public function withSenderStreet(string $street): PPEOptions
    {
        $new = clone $this;
        $new->sstreet = $street;

        return $new;
    }

    public function getSenderPhone(): string
    {
        return $this->sphone;
    }

    public function withSenderPhone(string $phone): PPEOptions
    {
        $new = clone $this;
        $new->sphone = $phone;

        return $new;
    }

    public function getSenderContactInfo(): string
    {
        return $this->scontact;
    }

    public function withSenderContactInfo(string $contact): PPEOptions
    {
        $new = clone $this;
        $new->scontact = $contact;

        return $new;
    }

    public function getRecipientName1(): string
    {
        return $this->rname1;
    }

    public function withRecipientName1(string $name1): PPEOptions
    {
        $new = clone $this;
        $new->rname1 = $name1;

        return $new;
    }

    public function getRecipientName2(): string
    {
        return $this->rname2;
    }

    public function withRecipientName2(string $name2): PPEOptions
    {
        $new = clone $this;
        $new->rname2 = $name2;

        return $new;
    }

    public function getRecipientName3(): string
    {
        return $this->rname3;
    }

    public function withRecipientName3(string $name3): PPEOptions
    {
        $new = clone $this;
        $new->rname3 = $name3;

        return $new;
    }

    public function getRecipientCountryIsoCode(): string
    {
        return $this->rcountry;
    }

    public function withRecipientCountryIsoCode(string $country): PPEOptions
    {
        $new = clone $this;
        $new->rcountry = $country;

        return $new;
    }

    public function getRecipientZipCode(): string
    {
        return $this->rzipcode;
    }

    public function withRecipientZipCode(string $zipCode): PPEOptions
    {
        $new = clone $this;
        $new->rzipcode = $zipCode;

        return $new;
    }

    public function getRecipientCity(): string
    {
        return $this->rcity;
    }

    public function withRecipientCity(string $city): PPEOptions
    {
        $new = clone $this;
        $new->rcity = $city;

        return $new;
    }

    public function getRecipientStreet(): string
    {
        return $this->rstreet;
    }

    public function withRecipientStreet(string $street): PPEOptions
    {
        $new = clone $this;
        $new->rstreet = $street;

        return $new;
    }

    public function getRecipientPhone(): string
    {
        return $this->rphone;
    }

    public function withRecipientPhone(string $phone): PPEOptions
    {
        $new = clone $this;
        $new->rphone = $phone;

        return $new;
    }

    public function getRecipientContactInfo(): string
    {
        return $this->rcontact;
    }

    public function withRecipientContactInfo(string $contact): PPEOptions
    {
        $new = clone $this;
        $new->rcontact = $contact;

        return $new;
    }

    public function getReferences(): string
    {
        return $this->references;
    }

    public function withReferences(string $references): PPEOptions
    {
        $new = clone $this;
        $new->references = $references;

        return $new;
    }

    public function getWeightKg(): float
    {
        return $this->weight;
    }

    public function withWeightKg(float $weight): PPEOptions
    {
        $new = clone $this;
        $new->weight = $weight;

        return $new;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
