<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\PreparingBox;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;
use Gls\GlsPoland\AdePlus\Consignment\Consignment;

final class Insert extends AuthorizedRequest
{
    private $consign_prep_data;

    public function __construct(Consignment $consignment)
    {
        $this->consign_prep_data = $consignment;
    }

    public function jsonSerialize(): array
    {
        return [
            'consign_prep_data' => $this->consign_prep_data,
        ];
    }

    public function getConsignment(): Consignment
    {
        return $this->consign_prep_data;
    }

    public function withConsignment(Consignment $consignment): Insert
    {
        $new = clone $this;
        $new->consign_prep_data = $consignment;

        return $new;
    }
}
