<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Download;

use Gls\GlsPoland\AdePlus\Printout\PrintModeInterface;
use Gls\GlsPoland\AdePlus\Printout\PrintoutInterface;

final class Base64EncodedFile implements StreamableFileInterface
{
    private $printout;
    private $printMode;

    public function __construct(PrintoutInterface $printout, PrintModeInterface $printMode)
    {
        $this->printout = $printout;
        $this->printMode = $printMode;
    }

    public function stream(): void
    {
        $outputStream = fopen('php://output', 'wb');
        stream_filter_append($outputStream, 'convert.base64-decode');
        fwrite($outputStream, $this->printout->getContents());
        fclose($outputStream);
    }

    public function getContentType(): string
    {
        return $this->printMode->getContentType();
    }

    public function getFileExtension(): string
    {
        return $this->printMode->getFileExtension();
    }
}
