<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Filters;

use Gls\GlsPoland\PrestaShop\Grid\Definition\Factory\CarrierGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Search\Filters;

final class CarrierFilters extends Filters
{
    protected $filterId = CarrierGridDefinitionFactory::GRID_ID;

    public static function getDefaults(): array
    {
        return [
            'limit' => 20,
            'offset' => 0,
            'orderBy' => 'id_reference',
            'sortOrder' => 'DESC',
            'filters' => [],
        ];
    }
}
